/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import org.jruby.EvalType;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.IdUtil;

@JRubyClass(name={"Struct"})
public class RubyStruct
extends RubyObject {
    public static final String NO_MEMBER_IN_STRUCT = "no member '%1$s' in struct";
    public static final String IDENTIFIER_NEEDS_TO_BE_CONSTANT = "identifier %1$s needs to be constant";
    public static final String UNINITIALIZED_CONSTANT = "uninitialized constant %1$s";
    private final IRubyObject[] values;
    private static final byte[] STRUCT_BEG = new byte[]{35, 60, 115, 116, 114, 117, 99, 116, 32};
    private static final byte[] STRUCT_END = new byte[]{58, 46, 46, 46, 62};
    private static final ObjectAllocator STRUCT_INSTANCE_ALLOCATOR = new ObjectAllocator(){

        @Override
        public RubyStruct allocate(Ruby runtime, RubyClass klass) {
            RubyStruct instance = new RubyStruct(runtime, klass);
            instance.setMetaClass(klass);
            return instance;
        }
    };
    private static final EqlRecursive EQL_RECURSIVE = new EqlRecursive();
    private static final HashRecursive HASH_RECURSIVE = new HashRecursive();
    private static final EqualRecursive EQUAL_RECURSIVE = new EqualRecursive();
    private static final ThreadContext.RecursiveFunctionEx INSPECT_RECURSIVE = new InspectRecursive();

    private RubyStruct(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
        int size2 = RubyNumeric.fix2int(RubyStruct.getInternalVariable(rubyClass, "__size__"));
        this.values = new IRubyObject[size2];
        Helpers.fillNil(this.values, runtime);
    }

    public static RubyClass createStructClass(Ruby runtime) {
        RubyClass structClass = runtime.defineClass("Struct", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setStructClass(structClass);
        structClass.setClassIndex(ClassIndex.STRUCT);
        structClass.includeModule(runtime.getEnumerable());
        structClass.defineAnnotatedMethods(RubyStruct.class);
        return structClass;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.STRUCT;
    }

    private static IRubyObject getInternalVariable(RubyClass type2, String internedName) {
        RubyClass structClass = type2.getRuntime().getStructClass();
        while (type2 != null && type2 != structClass) {
            IRubyObject variable = (IRubyObject)type2.getInternalVariable(internedName);
            if (variable != null) {
                return variable;
            }
            type2 = type2.getSuperClass();
        }
        return type2.getRuntime().getNil();
    }

    private RubyClass classOf() {
        return this.getMetaClass() instanceof MetaClass ? this.getMetaClass().getSuperClass() : this.getMetaClass();
    }

    private void modify() {
        this.testFrozen();
    }

    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        Ruby runtime = context.runtime;
        int h = this.getType().hashCode();
        IRubyObject[] values2 = this.values;
        for (int i2 = 0; i2 < values2.length; ++i2) {
            h = h << 1 | (h < 0 ? 1 : 0);
            IRubyObject hash2 = context.safeRecurse(HASH_RECURSIVE, runtime, values2[i2], "hash", true);
            h = (int)((long)h ^ RubyNumeric.num2long(hash2));
        }
        return runtime.newFixnum(h);
    }

    private IRubyObject setByName(String name2, IRubyObject value2) {
        RubyArray member = this.__member__();
        this.modify();
        for (int i2 = 0; i2 < member.getLength(); ++i2) {
            if (!member.eltInternal(i2).asJavaString().equals(name2)) continue;
            this.values[i2] = value2;
            return this.values[i2];
        }
        return null;
    }

    private IRubyObject getByName(String name2) {
        RubyArray member = this.__member__();
        for (int i2 = 0; i2 < member.getLength(); ++i2) {
            if (!member.eltInternal(i2).asJavaString().equals(name2)) continue;
            return this.values[i2];
        }
        return null;
    }

    @JRubyMethod(name={"new"}, required=1, rest=true, meta=true)
    public static RubyClass newInstance(IRubyObject recv2, IRubyObject[] args2, Block block) {
        int i2;
        RubyClass newStruct2;
        int i3;
        String name2 = null;
        boolean nilName = false;
        Ruby runtime = recv2.getRuntime();
        if (args2.length > 0) {
            IRubyObject firstArgAsString = args2[0].checkStringType();
            if (!firstArgAsString.isNil()) {
                name2 = ((RubyString)firstArgAsString).getByteList().toString();
            } else if (args2[0].isNil()) {
                nilName = true;
            }
        }
        RubyArray member = runtime.newArray();
        int n = i3 = name2 == null && !nilName ? 0 : 1;
        while (i3 < args2.length) {
            member.append(runtime.newSymbol(args2[i3].asJavaString()));
            ++i3;
        }
        RubyClass superClass = (RubyClass)recv2;
        if (name2 == null || nilName) {
            newStruct2 = RubyClass.newClass(runtime, superClass);
            newStruct2.setAllocator(STRUCT_INSTANCE_ALLOCATOR);
            newStruct2.makeMetaClass(superClass.getMetaClass());
            newStruct2.inherit(superClass);
        } else {
            if (!IdUtil.isConstant(name2)) {
                throw runtime.newNameError(IDENTIFIER_NEEDS_TO_BE_CONSTANT, recv2, name2);
            }
            IRubyObject type2 = superClass.getConstantAt(name2);
            if (type2 != null) {
                ThreadContext context = runtime.getCurrentContext();
                runtime.getWarnings().warn(IRubyWarnings.ID.STRUCT_CONSTANT_REDEFINED, context.getFile(), context.getLine(), "redefining constant " + type2);
                superClass.deleteConstant(name2);
            }
            newStruct2 = superClass.defineClassUnder(name2, superClass, STRUCT_INSTANCE_ALLOCATOR);
        }
        newStruct2.setReifiedClass(RubyStruct.class);
        newStruct2.setClassIndex(ClassIndex.STRUCT);
        newStruct2.setInternalVariable("__size__", member.length());
        newStruct2.setInternalVariable("__member__", member);
        newStruct2.getSingletonClass().defineAnnotatedMethods(StructMethods.class);
        int n2 = i2 = name2 == null && !nilName ? 0 : 1;
        while (i2 < args2.length) {
            String memberName = args2[i2].asJavaString();
            int index2 = name2 == null && !nilName ? i2 : i2 - 1;
            newStruct2.addMethod(memberName, new Accessor(newStruct2, memberName, index2));
            String nameAsgn = memberName + '=';
            newStruct2.addMethod(nameAsgn, new Mutator(newStruct2, nameAsgn, index2));
            ++i2;
        }
        if (block.isGiven()) {
            block.setEvalType(EvalType.MODULE_EVAL);
            block.getBinding().setVisibility(Visibility.PUBLIC);
            block.yieldNonArray(runtime.getCurrentContext(), newStruct2, newStruct2);
        }
        return newStruct2;
    }

    public static RubyStruct newStruct(IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyStruct struct = new RubyStruct(recv2.getRuntime(), (RubyClass)recv2);
        struct.callInit(args2, block);
        return struct;
    }

    public static RubyStruct newStruct(IRubyObject recv2, Block block) {
        RubyStruct struct = new RubyStruct(recv2.getRuntime(), (RubyClass)recv2);
        struct.callInit(block);
        return struct;
    }

    public static RubyStruct newStruct(IRubyObject recv2, IRubyObject arg0, Block block) {
        RubyStruct struct = new RubyStruct(recv2.getRuntime(), (RubyClass)recv2);
        struct.callInit(arg0, block);
        return struct;
    }

    public static RubyStruct newStruct(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyStruct struct = new RubyStruct(recv2.getRuntime(), (RubyClass)recv2);
        struct.callInit(arg0, arg1, block);
        return struct;
    }

    public static RubyStruct newStruct(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        RubyStruct struct = new RubyStruct(recv2.getRuntime(), (RubyClass)recv2);
        struct.callInit(arg0, arg1, arg2, block);
        return struct;
    }

    private void checkSize(int length2) {
        if (length2 > this.values.length) {
            throw this.getRuntime().newArgumentError("struct size differs (" + length2 + " for " + this.values.length + ")");
        }
    }

    @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        this.modify();
        this.checkSize(args2.length);
        System.arraycopy(args2, 0, this.values, 0, args2.length);
        Helpers.fillNil(this.values, args2.length, this.values.length, context.runtime);
        return context.nil;
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        IRubyObject nil = context.nil;
        return this.initializeInternal(context, 0, nil, nil, nil);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0) {
        IRubyObject nil = context.nil;
        return this.initializeInternal(context, 1, arg0, nil, nil);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.initializeInternal(context, 2, arg0, arg1, context.nil);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.initializeInternal(context, 3, arg0, arg1, arg2);
    }

    public IRubyObject initializeInternal(ThreadContext context, int provided, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        this.modify();
        this.checkSize(provided);
        switch (provided) {
            case 3: {
                this.values[2] = arg2;
            }
            case 2: {
                this.values[1] = arg1;
            }
            case 1: {
                this.values[0] = arg0;
            }
        }
        if (provided < this.values.length) {
            Helpers.fillNil(this.values, provided, this.values.length, context.runtime);
        }
        return context.nil;
    }

    public static RubyArray members(IRubyObject recv2, Block block) {
        Ruby runtime = recv2.getRuntime();
        RubyArray member = RubyStruct.__member__((RubyClass)recv2);
        int len = member.getLength();
        RubyArray result2 = RubyArray.newBlankArray(runtime, len);
        for (int i2 = 0; i2 < len; ++i2) {
            result2.store(i2, (IRubyObject)member.eltInternal(i2));
        }
        return result2;
    }

    private static RubyArray __member__(RubyClass clazz) {
        RubyArray member = (RubyArray)RubyStruct.getInternalVariable(clazz, "__member__");
        assert (!member.isNil()) : "uninitialized struct";
        return member;
    }

    private RubyArray __member__() {
        return RubyStruct.__member__(this.classOf());
    }

    public RubyArray members() {
        return this.members19();
    }

    @JRubyMethod(name={"members"})
    public RubyArray members19() {
        return RubyStruct.members19(this.classOf(), Block.NULL_BLOCK);
    }

    @JRubyMethod
    public IRubyObject select(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "select", this.enumSizeFn());
        }
        RubyArray array = RubyArray.newArray(context.runtime);
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            if (!block.yield(context, this.values[i2]).isTrue()) continue;
            array.append(this.values[i2]);
        }
        return array;
    }

    private RubyEnumerator.SizeFn enumSizeFn() {
        final RubyStruct self2 = this;
        return new RubyEnumerator.SizeFn(){

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                return self2.size();
            }
        };
    }

    public IRubyObject set(IRubyObject value2, int index2) {
        this.modify();
        this.values[index2] = value2;
        return this.values[index2];
    }

    private RaiseException notStructMemberError(IRubyObject name2) {
        return this.getRuntime().newNameError(NO_MEMBER_IN_STRUCT, (IRubyObject)this, name2);
    }

    public final IRubyObject get(int index2) {
        return this.values[index2];
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone2) {
        RubyStruct struct = (RubyStruct)clone2;
        System.arraycopy(this.values, 0, struct.values, 0, this.values.length);
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return context.tru;
        }
        if (!(other instanceof RubyStruct)) {
            return context.fals;
        }
        if (this.getType() != other.getType()) {
            return context.fals;
        }
        if (other == this) {
            return context.tru;
        }
        return context.safeRecurse(EQUAL_RECURSIVE, other, this, "==", true);
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return context.tru;
        }
        if (!(other instanceof RubyStruct)) {
            return context.fals;
        }
        if (this.getMetaClass() != other.getMetaClass()) {
            return context.fals;
        }
        if (other == this) {
            return context.tru;
        }
        return context.safeRecurse(EQL_RECURSIVE, other, this, "eql?", true);
    }

    private RubyString inspectStruct(ThreadContext context, boolean recur) {
        Ruby runtime = context.runtime;
        RubyString buffer = RubyString.newString(runtime, new ByteList(32));
        buffer.cat(STRUCT_BEG);
        String cname = this.getMetaClass().getRealClass().getName();
        char first2 = cname.charAt(0);
        if (recur || first2 != '#') {
            buffer.cat(cname.getBytes());
        }
        if (recur) {
            return buffer.cat(STRUCT_END);
        }
        RubyArray member = this.__member__();
        for (int i2 = 0; i2 < member.getLength(); ++i2) {
            if (i2 > 0) {
                buffer.cat(44).cat(32);
            } else if (first2 != '#') {
                buffer.cat(32);
            }
            RubySymbol slot = (RubySymbol)member.eltInternal(i2);
            String name2 = slot.toString();
            if (IdUtil.isLocal(name2) || IdUtil.isConstant(name2)) {
                buffer.cat19(RubyString.objAsString(context, slot));
            } else {
                buffer.cat19((RubyString)slot.inspect(context));
            }
            buffer.cat(61);
            buffer.cat19(RubyStruct.inspect(context, this.values[i2]));
        }
        buffer.cat(62);
        return (RubyString)buffer.infectBy(this);
    }

    @JRubyMethod(name={"inspect", "to_s"})
    public RubyString inspect(ThreadContext context) {
        return (RubyString)context.safeRecurse(INSPECT_RECURSIVE, this, this, "inspect", false);
    }

    @Override
    @JRubyMethod(name={"to_a", "values"})
    public RubyArray to_a() {
        return RubyArray.newArrayMayCopy(this.getRuntime(), this.values);
    }

    @JRubyMethod
    public RubyHash to_h(ThreadContext context) {
        RubyHash hash2 = RubyHash.newHash(context.runtime);
        RubyArray members2 = this.__member__();
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            hash2.op_aset(context, (IRubyObject)members2.eltOk(i2), this.values[i2]);
        }
        return hash2;
    }

    @JRubyMethod(name={"size", "length"})
    public RubyFixnum size() {
        return this.getRuntime().newFixnum(this.values.length);
    }

    public IRubyObject eachInternal(ThreadContext context, Block block) {
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            block.yield(context, this.values[i2]);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext context, Block block) {
        return block.isGiven() ? this.eachInternal(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "each", this.enumSizeFn());
    }

    public IRubyObject each_pairInternal(ThreadContext context, Block block) {
        RubyArray member = this.__member__();
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            block.yield(context, RubyArray.newArray(context.runtime, member.eltInternal(i2), this.values[i2]));
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each_pair(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_pairInternal(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "each_pair", this.enumSizeFn());
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject aref(IRubyObject key2) {
        return this.arefImpl(key2, false);
    }

    private IRubyObject arefImpl(IRubyObject key2, boolean nilOnNoMember) {
        if (key2 instanceof RubyString || key2 instanceof RubySymbol) {
            String name2 = key2.asJavaString();
            IRubyObject value2 = this.getByName(name2);
            if (value2 == null) {
                if (nilOnNoMember) {
                    return this.getRuntime().getNil();
                }
                throw this.notStructMemberError(key2);
            }
            return value2;
        }
        return this.aref(RubyNumeric.fix2int(key2));
    }

    final IRubyObject aref(int idx) {
        int newIdx;
        int n = newIdx = idx < 0 ? this.values.length + idx : idx;
        if (newIdx < 0) {
            throw this.getRuntime().newIndexError("offset " + idx + " too small for struct(size:" + this.values.length + ")");
        }
        if (newIdx >= this.values.length) {
            throw this.getRuntime().newIndexError("offset " + idx + " too large for struct(size:" + this.values.length + ")");
        }
        return this.values[newIdx];
    }

    @JRubyMethod(name={"[]="}, required=2)
    public IRubyObject aset(IRubyObject key2, IRubyObject value2) {
        if (key2 instanceof RubyString || key2 instanceof RubySymbol) {
            String name2 = key2.asJavaString();
            IRubyObject val = this.setByName(name2, value2);
            if (val == null) {
                throw this.notStructMemberError(key2);
            }
            return value2;
        }
        return this.aset(RubyNumeric.fix2int(key2), value2);
    }

    private IRubyObject aset(int idx, IRubyObject value2) {
        int newIdx;
        int n = newIdx = idx < 0 ? this.values.length + idx : idx;
        if (newIdx < 0) {
            throw this.getRuntime().newIndexError("offset " + idx + " too small for struct(size:" + this.values.length + ")");
        }
        if (newIdx >= this.values.length) {
            throw this.getRuntime().newIndexError("offset " + idx + " too large for struct(size:" + this.values.length + ")");
        }
        this.modify();
        this.values[newIdx] = value2;
        return this.values[newIdx];
    }

    @JRubyMethod(rest=true)
    public IRubyObject values_at(IRubyObject[] args2) {
        Ruby runtime = this.getRuntime();
        int olen = this.values.length;
        RubyArray result2 = runtime.newArray(args2.length);
        for (int i2 = 0; i2 < args2.length; ++i2) {
            IRubyObject arg2 = args2[i2];
            if (arg2 instanceof RubyFixnum) {
                result2.append(this.aref(arg2));
                continue;
            }
            if (arg2 instanceof RubyRange) {
                int[] beglen = ((RubyRange)args2[i2]).begLenInt(olen, 0);
                if (beglen == null) continue;
                int beg = beglen[0];
                int len = beglen[1];
                for (int j = 0; j < len; ++j) {
                    result2.append(this.aref(j + beg));
                }
                continue;
            }
            result2.append(this.aref(RubyNumeric.num2int(arg2)));
        }
        return result2;
    }

    @JRubyMethod(name={"dig"}, required=1, rest=true)
    public IRubyObject dig(ThreadContext context, IRubyObject[] args2) {
        return this.dig(context, args2, 0);
    }

    final IRubyObject dig(ThreadContext context, IRubyObject[] args2, int idx) {
        IRubyObject val = this.arefImpl(args2[idx++], true);
        return idx == args2.length ? val : RubyObject.dig(context, val, args2, idx);
    }

    public static void marshalTo(RubyStruct struct, MarshalStream output) throws IOException {
        output.registerLinkTarget(struct);
        output.dumpDefaultObjectHeader('S', struct.getMetaClass());
        RubyArray member = RubyStruct.__member__(struct.classOf());
        output.writeInt(member.size());
        for (int i2 = 0; i2 < member.size(); ++i2) {
            RubySymbol name2 = (RubySymbol)member.eltInternal(i2);
            output.dumpObject(name2);
            output.dumpObject(struct.values[i2]);
        }
    }

    public static RubyStruct unmarshalFrom(UnmarshalStream input) throws IOException {
        RubySymbol className;
        Ruby runtime = input.getRuntime();
        RubyClass rbClass = RubyStruct.pathToClass(runtime, (className = (RubySymbol)input.unmarshalObject(false)).asJavaString());
        if (rbClass == null) {
            throw runtime.newNameError(UNINITIALIZED_CONSTANT, (IRubyObject)runtime.getStructClass(), className);
        }
        RubyArray member = RubyStruct.__member__(rbClass);
        int len = input.unmarshalInt();
        RubyStruct result2 = new RubyStruct(runtime, rbClass);
        input.registerLinkTarget(result2);
        for (int i2 = 0; i2 < len; ++i2) {
            IRubyObject slot = input.unmarshalObject(false);
            Object elem = member.eltInternal(i2);
            if (!elem.toString().equals(slot.toString())) {
                throw runtime.newTypeError("struct " + rbClass.getName() + " not compatible (:" + slot + " for :" + elem + ")");
            }
            result2.aset(i2, input.unmarshalObject());
        }
        return result2;
    }

    private static RubyClass pathToClass(Ruby runtime, String path2) {
        return (RubyClass)runtime.getClassFromPath(path2);
    }

    @Override
    @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject arg2) {
        if (this == arg2) {
            return this;
        }
        RubyStruct original = (RubyStruct)arg2;
        this.checkFrozen();
        System.arraycopy(original.values, 0, this.values, 0, original.values.length);
        return this;
    }

    @Deprecated
    public static RubyArray members19(IRubyObject recv2, Block block) {
        return RubyStruct.members(recv2, block);
    }

    private static class InspectRecursive
    implements ThreadContext.RecursiveFunctionEx<RubyStruct> {
        private InspectRecursive() {
        }

        @Override
        public IRubyObject call(ThreadContext context, RubyStruct self2, IRubyObject obj, boolean recur) {
            return self2.inspectStruct(context, recur);
        }
    }

    private static class EqualRecursive
    implements ThreadContext.RecursiveFunctionEx<IRubyObject> {
        private EqualRecursive() {
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject other, IRubyObject self2, boolean recur) {
            if (recur) {
                return context.tru;
            }
            IRubyObject[] values2 = ((RubyStruct)self2).values;
            IRubyObject[] otherValues = ((RubyStruct)other).values;
            for (int i2 = 0; i2 < values2.length; ++i2) {
                if (RubyObject.equalInternal(context, values2[i2], otherValues[i2])) continue;
                return context.fals;
            }
            return context.tru;
        }
    }

    private static class HashRecursive
    implements ThreadContext.RecursiveFunctionEx<Ruby> {
        private HashRecursive() {
        }

        @Override
        public IRubyObject call(ThreadContext context, Ruby runtime, IRubyObject obj, boolean recur) {
            if (recur) {
                return RubyFixnum.zero(runtime);
            }
            return Helpers.invokedynamic(context, obj, MethodNames.HASH);
        }
    }

    private static class EqlRecursive
    implements ThreadContext.RecursiveFunctionEx<IRubyObject> {
        private EqlRecursive() {
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject other, IRubyObject self2, boolean recur) {
            if (recur) {
                return context.tru;
            }
            IRubyObject[] values2 = ((RubyStruct)self2).values;
            IRubyObject[] otherValues = ((RubyStruct)other).values;
            for (int i2 = 0; i2 < values2.length; ++i2) {
                if (RubyObject.eqlInternal(context, values2[i2], otherValues[i2])) continue;
                return context.fals;
            }
            return context.tru;
        }
    }

    private static class Mutator
    extends DynamicMethod {
        private final int index;

        public Mutator(RubyClass newStruct2, String name2, int index2) {
            super((RubyModule)newStruct2, Visibility.PUBLIC, name2);
            this.index = index2;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            Arity.checkArgumentCount(context.runtime, name2, args2, 1, 1);
            return ((RubyStruct)self2).set(args2[0], this.index);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg2) {
            return ((RubyStruct)self2).set(arg2, this.index);
        }

        @Override
        public DynamicMethod dup() {
            return new Mutator((RubyClass)this.getImplementationClass(), this.name, this.index);
        }
    }

    private static class Accessor
    extends DynamicMethod {
        private final int index;

        public Accessor(RubyClass newStruct2, String name2, int index2) {
            super((RubyModule)newStruct2, Visibility.PUBLIC, name2);
            this.index = index2;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            Arity.checkArgumentCount(context.runtime, name2, args2, 0, 0);
            return ((RubyStruct)self2).get(this.index);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
            return ((RubyStruct)self2).get(this.index);
        }

        @Override
        public DynamicMethod dup() {
            return new Accessor((RubyClass)this.getImplementationClass(), this.name, this.index);
        }
    }

    public static class StructMethods {
        @JRubyMethod(name={"new", "[]"}, rest=true)
        public static IRubyObject newStruct(IRubyObject recv2, IRubyObject[] args2, Block block) {
            return RubyStruct.newStruct(recv2, args2, block);
        }

        @JRubyMethod(name={"new", "[]"})
        public static IRubyObject newStruct(IRubyObject recv2, Block block) {
            return RubyStruct.newStruct(recv2, block);
        }

        @JRubyMethod(name={"new", "[]"})
        public static IRubyObject newStruct(IRubyObject recv2, IRubyObject arg0, Block block) {
            return RubyStruct.newStruct(recv2, arg0, block);
        }

        @JRubyMethod(name={"new", "[]"})
        public static IRubyObject newStruct(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, Block block) {
            return RubyStruct.newStruct(recv2, arg0, arg1, block);
        }

        @JRubyMethod(name={"new", "[]"})
        public static IRubyObject newStruct(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            return RubyStruct.newStruct(recv2, arg0, arg1, arg2, block);
        }

        @JRubyMethod
        public static IRubyObject members(IRubyObject recv2, Block block) {
            return RubyStruct.members19(recv2, block);
        }
    }
}

